%Example: Run a simulation with a heavy-duty conventional vehicle
clear

%% Create a vehicle configuration, load the mission
conf = vehConf('conv');
conf.vehicle_name = "S-Way";
conf.finalDrive_name = "FPT_heavy_2_85";
conf.transmission_name = "ZF_HDV";
conf.engine_name = "FPT_338kW";

% Create the vehicle data using createConfiguration
veh = createVehicle(conf);

% Select the mission. This must be an existing .mat file in the library
mission_name = "LongHaul";

%% Run simulation
[results, veh, prof, info] = vehicleSim(veh, mission_name);

%% Plot
% Plot default profiles as a function of traveled distance
mainProfiles(prof, veh, "def", "dist");

% Plot selected profiles
mainProfiles(prof, veh, ["rollForce", "dragForce", "gradeForce", "inertiaForce"], "dist");

% Plot the engine operating points
engMapOperation(veh.eng, prof, 'bsfc')